#include <iostream>
#include <cstdio>
#include <vector>
#include <set>
#include <algorithm>

using namespace std;

const int maxn = 1 << 17;
const int inf = 2.1e9;

struct Edge {
	int u, v, w;
	Edge() {}
	Edge(int u, int v, int w) : u(u), v(v), w(w) {}

	int go(int x) {
		if (u == x) return v;
		return u;
	}
};

int n, m;
vector<int> e[maxn], g[maxn];
vector<Edge> edges;
int d[2][maxn];
set<pair<int, int> > st;
int in[maxn], out[maxn], cnt;
int vis[maxn];
vector<int> ans;

void dijkstra(int *d, int v) {
	for (int i = 1; i <= n; i++) {
		d[i] = inf;
	}
	d[v] = 0;
	for (int i = 1; i <= n; i++) {
		st.insert(make_pair(d[i], i));
	}
	while (!st.empty()) {
		int v = st.begin()->second;
		st.erase(st.begin());
		for (int i = 0; i < (int)e[v].size(); i++) {
			int to = edges[e[v][i]].go(v);
			int cost = edges[e[v][i]].w;
			if (d[to] > d[v] + cost) {
				st.erase(make_pair(d[to], to));
				d[to] = d[v] + cost;
				st.insert(make_pair(d[to], to));
			}
		}
	}
}

void dfs(int v, int p) {
	vis[v] = 1;
	in[v] = out[v] = cnt++;
	for (int i = 0; i < (int)g[v].size(); i++) {
		int to = edges[g[v][i]].go(v);
		if (g[v][i] == p) continue;
		if (vis[to]) {
			out[v] = min(out[v], in[to]);
		} else {
			dfs(to, g[v][i]);
			out[v] = min(out[v], out[to]);
		}
		if (out[to] > in[v]) {
			ans.push_back(g[v][i] + 1);
		}
	}
}

int main() {
	//freopen("input.txt", "r", stdin);

	cin >> n >> m;
	for (int i = 0; i < m; i++) {
		int u, v, w;
		cin >> u >> v >> w;
		e[u].push_back(edges.size());
		e[v].push_back(edges.size());
		edges.push_back(Edge(u, v, w));
	}

	dijkstra(d[0], 1);
	dijkstra(d[1], n);
	
	for (int i = 0; i < (int)edges.size(); i++) {
		int u = edges[i].u, v = edges[i].v, w = edges[i].w;
		if (d[0][u] + w == d[0][v] && d[0][n] == d[0][v] + d[1][v] || d[0][v] + w == d[1][u] && d[0][n] == d[0][u] + d[1][u]) {
			g[u].push_back(i);
			g[v].push_back(i);
		}
	}

	dfs(1, -1);

	sort(ans.begin(), ans.end());
	cout << ans.size() << endl;
	for (int i = 0; i < (int)ans.size(); i++) cout << ans[i] << " \n"[i + 1 == (int)ans.size()];

	return 0;
}